<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <!-- <title>SB Admin 2 - Dashboard</title> -->
  <title><?php echo e(config('app.name')); ?> - <?php echo $__env->yieldContent('title', 'IMG'); ?></title>

  
  <?php if($app_settings[0]->custom_favicon == null): ?>
  <link rel="icon" href="<?php echo e(asset('/images/favicon.png')); ?>" type="image/x-icon"/>
  <?php else: ?>
  <link rel="icon" href="<?php echo e(asset('/images/custom_favicon/'.$app_settings[0]->custom_favicon)); ?>" type="image/x-icon"/>
  <?php endif; ?>

  <!-- Custom fonts for this template-->
  <link href="<?php echo e(asset('/sb-admin/vendor/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css">
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
  
  <!-- Custom styles for this template-->
  <link href="<?php echo e(asset('sb-admin/css/sb-admin-2.css')); ?>" rel="stylesheet">
  <style>
    input[type=checkbox]{
      width: 3rem;
    }
  </style>
  <?php echo $__env->yieldContent('custom-css'); ?>
</head>
<body id="page-top">
<!-- vue instance -->
<div id="app">
  <!-- Page Wrapper -->
  <div id="wrapper">
    <!-- Sidebar -->
    <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End of Sidebar -->
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">
      <!-- Main Content -->
      <div id="content">
        <!-- Topbar -->
        <?php echo $__env->make('layouts.top_search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End of Topbar -->
        <!-- Begin Page Content -->
        <div class="container-fluid">
          <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- /.container-fluid -->
      </div>
      <!-- End of Main Content -->
      <!-- Footer -->
      <footer class="sticky-footer">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; VORX <?php echo e(Carbon\Carbon::now()->year); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->
    </div>
    <!-- End of Content Wrapper -->
  </div>
  <!-- End of Page Wrapper -->
  <!-- Scroll to Top Button-->
  
  <!-- Logout Modal-->
  <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header bg-<?php echo e($app_settings[0]->app_color); ?> text-white">
          <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
          <button class="close" type="button" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true" class="text-white">×</span>
          </button>
        </div>
        <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
        <div class="modal-footer">
          <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>                           
          <a class="btn btn-primary" href="<?php echo e(route('logout')); ?>"
          onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();">Logout</a>
            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
            </form>
        </div>
      </div>
    </div>
  </div>
</div>
  <!-- Bootstrap core JavaScript-->
  
  <!-- Core plugin JavaScript-->
  
  <!-- Custom scripts for all pages-->
  
  <?php echo $__env->make('layouts.php-js-vars', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  
  <?php echo $__env->yieldContent('custom-js'); ?>
  <script src="<?php echo e(asset('/sb-admin/js/sb-admin-2.min.js')); ?>"></script>
</body>
</html><?php /**PATH /home/kaurcomowner/public_html/vorx_img/resources/views/layouts/admin.blade.php ENDPATH**/ ?>