<!DOCTYPE html>
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link type="text/css" href="<?php echo e(public_path()); ?>/client-details-report/pdf-style.css" rel="stylesheet" />
	<title>Kaurmigration - Client Details</title>
</head>
<?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
$notes_strlen = 0;
$convo_strlen = 0;
$total_strlen = 0;
?>

<?php if(count($client->notes) > 0): ?>
	<?php $__currentLoopData = $client->notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<?php $notes_strlen = $notes_strlen + strlen($note->remarks) ?>
	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<?php if(count($client->convos) > 0): ?>
	<?php $__currentLoopData = $client->convos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $convo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<?php $convo_strlen = $convo_strlen + strlen($convo->remarks) ?>
	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<?php 
$total_strlen = $notes_strlen + $convo_strlen; 
?>
<body class="position-relative">
<div class="pdf-wrapper">
		<div class="header-section">
			<img src="<?php echo e(public_path()); ?>/client-details-report/images/kaurmigration-logo-colored.jpg" class="logo">
		</div>
		<div class="clearfix" style="height: 15px;"></div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Client ID:</b> <?php echo e($client->client_detail->customer_id); ?></td>
				<td width="40%"><b>Deal Type:</b> <?php echo e($client->deal_type->type); ?></td>
			</tr>
			<tr>
				<td width="60%"></td>
				<td width="40%"><b>Deal Source:</b> 
				<?php if(isset($client->deal_source->source_name)): ?>
					<?php echo e($client->deal_source->source_name); ?>

				<?php endif; ?>
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 10px;"></div>
		<div class="heading">Client Details</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Full Name:</b> <?php echo e($client->party->name); ?></td>
				<td width="40%"><b>Date of Birth:</b> 
					<?php if(isset($client->party->person->date_of_birth)): ?>
						<?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d', $client->party->person->date_of_birth)->format('d/m/Y')); ?> 
					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Email Address:</b> <?php echo e($client->party->person->contact_detail->email); ?></td>
				<td width="40%"><b>Alternative Email:</b> 
					<?php if(isset($client->party->person->contact_detail->email_alt)): ?>
						<?php echo e($client->party->person->contact_detail->email_alt); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Nationality:</b> 
					<?php if(isset($client->client_detail->nationality->nationality)): ?>
						<?php echo e($client->client_detail->nationality->nationality); ?>

					<?php endif; ?>
				</td>
				<td width="40%"><b>Phone #1:</b> 
					<?php if(isset($client->party->person->contact_detail->phones[0])): ?>
						<?php echo e($client->party->person->contact_detail->phones[0]); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Phone #2:</b> 
					<?php if(isset($client->party->person->contact_detail->phones[1])): ?>
						<?php echo e($client->party->person->contact_detail->phones[1]); ?>

					<?php endif; ?>
				</td>
				<td width="40%"><b>Phone #3:</b> 
					<?php if(isset($client->party->person->contact_detail->phones[2])): ?>
						<?php echo e($client->party->person->contact_detail->phones[2]); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>5th Call:</b> <?php echo e($client->client_detail->fifth_call == 1 ? 'Yes' : 'No'); ?></td>
			</tr>
		</table>
		<div class="clearfix" style="height: 10px;"></div>
		<div class="heading">Client Address</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Address:</b> <?php echo e($client->party->person->contact_detail->address_1); ?></td>
				<td width="40%"><b>State:</b> <?php echo e($client->party->person->contact_detail->state); ?></td>
			</tr>
			<tr>
				<td width="60%"><b>Postcode:</b> <?php echo e($client->party->person->contact_detail->postcode); ?></td>
				<td width="40%"><b>Country:</b> 
					<?php if(isset($client->party->person->contact_detail->country->full_name)): ?>
						<?php echo e($client->party->person->contact_detail->country->full_name); ?>

					<?php endif; ?>
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 10px;"></div>
		<div class="heading">Client Visa and Passport</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Passport:</b> 
					<?php if(isset($client->client_detail->passport)): ?>
						<?php echo e($client->client_detail->passport); ?>

					<?php endif; ?>
				</td>
				<td width="40%"><b>Visa Status:</b> 
					<?php if(isset($client->client_detail->visa_status->visa)): ?>
						<?php echo e($client->client_detail->visa_status->visa); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>Expiration Date:</b> 
					<?php if(isset($client->client_detail->expiration_date)): ?>
						<?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d', $client->client_detail->expiration_date)->format('d/m/Y')); ?>

					<?php endif; ?>
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 10px;"></div>
		<div class="heading">Client Other Details</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>College Currently Enrolled:</b> 
					<?php if(isset($client->client_detail->college_currently_enroled)): ?>
						<?php echo e($client->client_detail->college_currently_enroled); ?>

					<?php endif; ?>
				</td>
				<td width="40%"><b>Client Member Card No.:</b> 
					<?php if(isset($client->client_detail->client_member_card_no)): ?>
						<?php echo e($client->client_detail->client_member_card_no); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Referrer:</b> 
					<?php if(isset($client->client_detail->referrer->deal->party->name)): ?>
						<?php echo e($client->client_detail->referrer->deal->party->name); ?>

					<?php endif; ?>
				</td>
				<td width="40%"><b>Assigned To:</b> 
					<?php if(isset($client->client_detail->assigned->party->name)): ?>
						<?php echo e($client->client_detail->assigned->party->name); ?>

					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>Date Created:</b> 
					<?php if(isset($client->created_at)): ?>
						<?php echo e(\Carbon\Carbon::parse($client->created_at)->format('d/m/Y')); ?>

					<?php endif; ?>
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 10px;"></div>
		<div class="heading">Notes</div>
		<?php if(count($client->notes) > 0): ?>
			<?php $__currentLoopData = $client->notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<ul class="longtext-list">
				<li><b><?php echo e(\Carbon\Carbon::parse($note->note_date)->format('d/m/Y h:i:s A')); ?></b> <br> <?php echo e($note->remarks); ?></li>
			</ul>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php else: ?>
			<p class="text-center">No Notes</p>
		<?php endif; ?>
		<!-- <p><?php echo e($convo_strlen); ?></p> -->
		<?php if($total_strlen < 3000): ?>
			<div class="clearfix" style="height: 10px;"></div>
			<div class="heading">Conversation</div>
			<?php if(count($client->convos) > 0): ?>
				<?php $__currentLoopData = $client->convos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $convo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<ul class="longtext-list">
					<li><b><?php echo e(\Carbon\Carbon::parse($convo->note_date)->format('d/m/Y h:i:s A')); ?></b> <br> <?php echo e($convo->remarks); ?></li>
				</ul>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			<?php else: ?>
				<p class="text-center">No Conversation</p>
			<?php endif; ?>
		<?php endif; ?>
	</div>
</body>
<!-- 2nd Page -->
<?php if($total_strlen > 3000): ?>
<body class="position-relative">
	<div class="pdf-wrapper">
		<div class="header-section">
			<img src="<?php echo e(public_path()); ?>/client-details-report/images/kaurmigration-logo-colored.jpg" class="logo">
		</div>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Conversation (<?php echo e($client->client_detail->customer_id); ?> - <?php echo e($client->party->name); ?>)</div>
		<?php if(count($client->convos) > 0): ?>
			<?php $__currentLoopData = $client->convos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $convo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<ul class="longtext-list">
				<li><b><?php echo e(\Carbon\Carbon::parse($convo->note_date)->format('d/m/Y h:i:s A')); ?></b> <br> <?php echo e($convo->remarks); ?></li>
			</ul>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php else: ?>
			<p class="text-center">No Conversation</p>
		<?php endif; ?>
	</div>
</body>
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</html><?php /**PATH /home/kaurcomowner/public_html/vorx_img/resources/views/reports/client-list-pdf.blade.php ENDPATH**/ ?>