<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'select_page'], function () {
    Auth::routes();
    //student login
    Route::get('/student-login','Auth\LoginController@student_login');
    
    // Route::get('/', function () {
    //     return view('welcome');
    // });
    
    // Master Conversion
    Route::get('/master-convert', 'Master\ConvertMasterController@convert');
    
    
    Route::get('/dashboard', 'HomeController@index')->name('home');
    Route::get('/', 'HomeController@index')->name('home');
    Route::get('/dynamic-form', 'HomeController@dynamic_form')->name('dynamic-form');
    
    Route::get('/migrate-students', 'Migration\MigrationController@migrate_students')->name('migrate_students');
    
    Route::get('/get-user-nav', 'HomeController@get_user_nav');
    Route::get('/get-stud-status-alert', 'HomeController@student_status_alert');
    
    Route::group(['middleware' => 'web'], function () {
        Route::get('/centralized-login/{username}/{password}', 'Auth\LoginController@centralized_login');
        Route::get('/check-rto/{org_id}', 'Auth\LoginController@check_rto');
    });
    
    
    Route::get('/api-test', 'Master\MasterController@api_test');

});



// fetch completed status enrolment applications
// Route::get('enrolment/fetch', 'HomeController@fetch_enrolments');




