<?php


// 
Route::get('client/list', 'Deals\ClientController@list');
Route::get('referrer-search/{search}', 'Deals\ClientController@search_referrer');

// client queries
Route::get('/client-query', 'Deals\ClientController@client_query');

// client queries convert to prospect
Route::get('/client-query/convert-to-prospect/{id}', 'Deals\ClientController@lead_to_prospect');

Route::post('client/deal-update', 'Deals\ClientController@update_deals');

// update client details
Route::post('/client-detail/update', 'Deals\ClientController@update_client_detail');

// client notes
Route::get('/client-notes/{id}/{type}', 'Deals\DealNotesController@show');

// Client Notes Resource
Route::resource('deal-notes', 'Deals\DealNotesController');

// top search for clients
Route::get('/client/top-search/{search}', 'Deals\ClientController@top_search');


// Client Resource
Route::resource('client', 'Deals\ClientController');


// Create Attachment Folder
Route::post('client/attachment/rename-folder', 'Deals\DealAttachmentController@rename_folder');
Route::get('client/attachment/folders/{id}', 'Deals\DealAttachmentController@show_attachment_folders');
Route::delete('client/attachment/delete-folder/{id}', 'Deals\DealAttachmentController@delete_folder');
Route::post('client/attachment/create-folder', 'Deals\DealAttachmentController@create_folder');

// Client Attachments
Route::get('client/attachments/fetch/{id}/{folder_id}', 'Deals\DealAttachmentController@show');
Route::post('client/attachments/upload/{deal_id}', 'Deals\DealAttachmentController@store');
Route::get('client/attachments/preview/{id}', 'Deals\DealAttachmentController@preview');
Route::delete('client/attachments/destroy/{id}', 'Deals\DealAttachmentController@destroy');
Route::put('client/attachments/rename/{id}', 'Deals\DealAttachmentController@rename');
Route::get('client/attachments/download/{id}', 'Deals\DealAttachmentController@download');



// Route::get('client-list','Deals\DealController@index');

// Client Invoice Resource
Route::resource('invoice', 'Deals\DealInvoiceController');

// Client Payment Resource
Route::resource('payment', 'Deals\DealPaymentController');

// Reminders Route
Route::resource('reminder', 'Deals\ClientReminderController');

// Reminders List (ALL)
Route::get('/client-reminders', 'Deals\ClientReminderController@index');
Route::get('/fetch-reminders', 'Deals\ClientReminderController@fetch_reminders');

Route::get('/reminder-list', 'Deals\ClientReminderController@reminder_list');
Route::post('/reminder/done', 'Deals\ClientReminderController@is_done');


// Services
Route::resource('service', 'Deals\ClientServiceController');

// per Client Reports
Route::post('/client-report/export-excel-list', 'Deals\ClientReportController@client_details');
Route::get('/client-report/download/{type}/{file}/{rename}', 'Deals\ClientReportController@download');
Route::get('/client-report/pdf/{id}', 'Deals\ClientReportController@generate_pdf');
