<!DOCTYPE html>
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link type="text/css" href="{{public_path()}}/client-details-report/pdf-style.css" rel="stylesheet" />
	<title>Kaurmigration - Client Details</title>
</head>
@php
$notes_strlen = 0;
$convo_strlen = 0;
$total_strlen = 0;
@endphp

@if(count($client->notes) > 0)
	@foreach ($client->notes as $k => $note)
		@php $notes_strlen = $notes_strlen + strlen($note->remarks) @endphp
	@endforeach
@endif

@if(count($client->convos) > 0)
	@foreach ($client->convos as $k => $convo)
		@php $convo_strlen = $convo_strlen + strlen($convo->remarks) @endphp
	@endforeach
@endif

@php 
$total_strlen = $notes_strlen + $convo_strlen; 
@endphp
<body class="position-relative">
	<div class="pdf-wrapper">
		<div class="header-section">
			<img src="{{public_path()}}/client-details-report/images/kaurmigration-logo-colored.jpg" class="logo">
		</div>
		<div class="clearfix" style="height: 25px;"></div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Client ID:</b> {{ $client->client_detail->customer_id }}</td>
				<td width="40%"><b>Deal Type:</b> {{ $client->deal_type->type }}</td>
			</tr>
			<tr>
				<td width="60%"></td>
				<td width="40%"><b>Deal Source:</b> 
				@if(isset($client->deal_source->source_name))
					{{ $client->deal_source->source_name }}
				@endif
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Client Details</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Full Name:</b> {{ $client->party->name }}</td>
				<td width="40%"><b>Date of Birth:</b> 
					@if(isset($client->party->person->date_of_birth))
						{{ \Carbon\Carbon::createFromFormat('Y-m-d', $client->party->person->date_of_birth)->format('d/m/Y') }} 
					@endif
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Email Address:</b> {{ $client->party->person->contact_detail->email }}</td>
				<td width="40%"><b>Alternative Email:</b> 
					@if(isset($client->party->person->contact_detail->email_alt))
						{{ $client->party->person->contact_detail->email_alt }}
					@endif
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Nationality:</b> 
					@if(isset($client->client_detail->nationality->nationality))
						{{ $client->client_detail->nationality->nationality }}
					@endif
				</td>
				<td width="40%"><b>Phone #1:</b> 
					@if(isset($client->party->person->contact_detail->phones[0]))
						{{ $client->party->person->contact_detail->phones[0] }}
					@endif
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Phone #2:</b> 
					@if(isset($client->party->person->contact_detail->phones[1]))
						{{ $client->party->person->contact_detail->phones[1] }}
					@endif
				</td>
				<td width="40%"><b>Phone #3:</b> 
					@if(isset($client->party->person->contact_detail->phones[2]))
						{{ $client->party->person->contact_detail->phones[2] }}
					@endif
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>5th Call:</b> {{ $client->client_detail->fifth_call == 1 ? 'Yes' : 'No' }}</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Client Address</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Address:</b> {{ $client->party->person->contact_detail->address_1 }}</td>
				<td width="40%"><b>State:</b> {{ $client->party->person->contact_detail->state }}</td>
			</tr>
			<tr>
				<td width="60%"><b>Postcode:</b> {{ $client->party->person->contact_detail->postcode }}</td>
				<td width="40%"><b>Country:</b> 
					@if(isset($client->party->person->contact_detail->country->full_name))
						{{ $client->party->person->contact_detail->country->full_name }}
					@endif
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Client Visa and Passport</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>Passport:</b> 
					@if(isset($client->client_detail->passport))
						{{ $client->client_detail->passport }}
					@endif
				</td>
				<td width="40%"><b>Visa Status:</b> 
					@if(isset($client->client_detail->visa_status->visa))
						{{ $client->client_detail->visa_status->visa }}
					@endif
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>Expiration Date:</b> 
					@if(isset($client->client_detail->expiration_date))
						{{ \Carbon\Carbon::createFromFormat('Y-m-d', $client->client_detail->expiration_date)->format('d/m/Y') }}
					@endif
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Client Other Details</div>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td width="60%"><b>College Currently Enrolled:</b> 
					@if(isset($client->client_detail->college_currently_enroled))
						{{ $client->client_detail->college_currently_enroled }}
					@endif
				</td>
				<td width="40%"><b>Client Member Card No.:</b> 
					@if(isset($client->client_detail->client_member_card_no))
						{{ $client->client_detail->client_member_card_no }}
					@endif
				</td>
			</tr>
			<tr>
				<td width="60%"><b>Referrer:</b> 
					@if(isset($client->client_detail->referrer->deal->party->name))
						{{ $client->client_detail->referrer->deal->party->name }}
					@endif
				</td>
				<td width="40%"><b>Assigned To:</b> 
					@if(isset($client->client_detail->assigned->party->name))
						{{ $client->client_detail->assigned->party->name }}
					@endif
				</td>
			</tr>
			<tr>
				<td colspan="2"><b>Date Created:</b> 
					@if(isset($client->created_at))
						{{ \Carbon\Carbon::parse($client->created_at)->format('d/m/Y') }}
					@endif
				</td>
			</tr>
		</table>
		<div class="clearfix" style="height: 15px;"></div>
		<div class="heading">Notes</div>
		@if(count($client->notes) > 0)
			@foreach ($client->notes as $k => $note)
			<ul class="longtext-list">
				<li><b>{{ \Carbon\Carbon::parse($note->note_date)->format('d/m/Y h:i:s A') }}</b> <br> {{ $note->remarks }}</li>
			</ul>
			@endforeach
		@else
			<p class="text-center">No Notes</p>
		@endif

		@if($total_strlen < 3000)
			<div class="clearfix" style="height: 15px;"></div>
			<div class="heading">Conversation</div>
			@if(count($client->convos) > 0)
				@foreach ($client->convos as $k => $convo)
				<ul class="longtext-list">
					<li><b>{{ \Carbon\Carbon::parse($convo->note_date)->format('d/m/Y h:i:s A') }}</b> <br> {{ $convo->remarks }}</li>
				</ul>
				@endforeach
			@else
				<p class="text-center">No Conversation</p>
			@endif
		@endif
	</div>
</body>
<!-- 2nd Page -->
@if($total_strlen > 3000)
<body class="position-relative">
	<div class="pdf-wrapper">
		<div class="header-section">
			<img src="{{public_path()}}/client-details-report/images/kaurmigration-logo-colored.jpg" class="logo">
		</div>
		<div class="clearfix" style="height: 25px;"></div>
		<div class="heading">Conversation</div>
		@if(count($client->convos) > 0)
			@foreach ($client->convos as $k => $convo)
			<ul class="longtext-list">
				<li><b>{{ \Carbon\Carbon::parse($convo->note_date)->format('d/m/Y h:i:s A') }}</b> <br> {{ $convo->remarks }}</li>
			</ul>
			@endforeach
		@else
			<p class="text-center">No Conversation</p>
		@endif
		
		
	</div>
</body>
@endif
</html>