<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCommentsToDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deals', 'comments')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->text('comments')->nullable()->after('is_online_inquiry');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'comments')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['comments']);
            });
        }
    }
}
