<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsOnlineInquiryToDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deals', 'is_online_inquiry')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->tinyInteger('is_online_inquiry')->default(0)->after('is_test');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'is_online_inquiry')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['is_online_inquiry']);
            });
        }
    }
}
