<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddHomeCountryResAddrToContactDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('contact_details', 'home_country_res_addr')) {
            Schema::table('contact_details', function (Blueprint $table) {
                $table->string('home_country_res_addr', 255)->nullable()->after('address_2');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('contact_details', 'home_country_res_addr')) {
            Schema::table('contact_details', function (Blueprint $table) {
                $table->dropColumn(['home_country_res_addr']);
            });
        }
    }
}
