<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionnaireAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('questionnaire_attachments')) {
            Schema::create('questionnaire_attachments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('questionnaire_id');
                $table->string('path', 255)->nullable();
                $table->string('name', 255)->nullable();
                $table->string('hash_name', 255)->nullable();
                $table->integer('size')->nullable();
                $table->string('mime_type', 50)->nullable();
                $table->string('ext', 10)->nullable();
                $table->string('_input', 255)->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('questionnaire_attachments');
    }
}
