<?php

use App\Models\ServiceType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('service_types')) {
            Schema::create('service_types', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type', 191);
                $table->timestamps();
                $table->softDeletes();
            });

            $types = ['Passport', 'Visa', 'Provisional Skills Assessment (PSA)', 'Admission'];
            foreach ($types as $k => $v) {
                $st = new ServiceType([
                    'type' => $v,
                ]);
                $st->save();
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_types');
    }
}
