<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('client_services')) {
            Schema::create('client_services', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('deal_id')->nullable();
                $table->string('service_code', 10)->nullable();
                $table->string('service_name')->nullable();
                $table->longText('service_details')->nullable();
                $table->decimal('amount', 11, 2)->nullable();
                $table->date('date_approved')->nullable();
                $table->date('date_expired')->nullable();
                $table->tinyInteger('is_withdrawn')->default(0);
                $table->tinyInteger('assigned_to_id')->nullable();
                $table->timestamps();
                $table->softDeletes();   
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_services');
    }
}
