<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTaskOrganiserIdInUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasColumn('users', 'task_organiser_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->integer('task_organiser_id')->nullable()->after('profile_image');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });

        if (Schema::hasColumn('users', 'task_organiser_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn(['task_organiser_id']);
            });
        }
    }
}
