<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCustomFaviconInOrganisationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('organisations', 'custom_favicon')) {
            Schema::table('organisations', function (Blueprint $table) {
                $table->string('custom_favicon', 191)->nullable()->after('logo_background_color');
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('organisations', 'custom_favicon')) {
            Schema::table('organisations', function (Blueprint $table) {
                $table->dropColumn(['custom_favicon']);
            });
        }
        
    }
}
