<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsTestInDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasColumn('deals', 'is_test')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->tinyInteger('is_test')->default(0)->after('active_date');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'is_test')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['is_test']);
            });
        }
    }
}
