<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsDoneInClientRemindersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('client_reminders', 'is_done')) {
            Schema::table('client_reminders', function (Blueprint $table) {
                $table->tinyInteger('is_done')->default(0)->after('is_sent');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('client_reminders', 'is_done')) {
            Schema::table('client_reminders', function (Blueprint $table) {
                $table->dropColumn(['is_done']);
            });
        }
    }
}
