<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNoAttahcmentInDealAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasColumn('deal_attachments', 'no_attachment')) {
            Schema::table('deal_attachments', function (Blueprint $table) {
                $table->tinyInteger('no_attachment')->default(0)->after('path');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deal_attachments', 'no_attachment')) {
            Schema::table('deal_attachments', function (Blueprint $table) {
                $table->dropColumn(['no_attachment']);
            });
        }
    }
}
