<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientRemindersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('client_reminders')) {
            Schema::create('client_reminders', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('deal_id');
                $table->string('subject', '255')->nullable();
                $table->text('content')->nullable();
                $table->text('reminders_to')->nullable();
                $table->date('reminder_date')->nullable();
                $table->string('reminder_time', 255)->nullable();
                $table->tinyInteger('is_active')->default(1);
                $table->integer('user_id')->nullable();
                $table->tinyInteger('is_sent')->default(0);
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_reminders');
    }
}
