<?php

use App\Models\PaymentMethod;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentMethodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('payment_methods')) {
            Schema::create('payment_methods', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('method', 255)->nullable();
                $table->timestamps();
            });

            $types = [
                'Direct Debit', 
                'Bank Transfers / Deposit', 
                'Mobile Payments', 
                'Cash', 
                'Debit Card',
                'Cheque',
                'EFTPOS',
            ];

            foreach ($types as $value) {
                $dt = new PaymentMethod;
                $dt->method = $value;
                $dt->save();
            }
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
}
