<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('payments')) {
            Schema::create('payments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('old_payment_id')->nullable();
                $table->bigInteger('invoice_id');
                $table->dateTime('payment_date')->nullable();
                $table->string('trxn_code', 191)->nullable();
                $table->text('remarks')->nullable();
                $table->enum('payment_type', ['INITIAL_PAYMENT', 'MONTHLY_DUE', 'TRANSACTION'])->default('TRANSACTION');
                $table->enum('source', ['ETI_SITE', 'CRM', 'TRXN'])->default('TRXN');
                $table->decimal('amount', 11, 2)->default('0.00');
                $table->integer('user_id')->nullable();
                $table->enum('status', ['Open', 'Pending', 'Success', 'Complete', 'Cancelled', 'Rejected'])->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
