<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('invoice_details')) {
            Schema::create('invoice_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('old_invoice_detail_id')->nullable();
                $table->bigInteger('invoice_id');
                $table->string('line_item_title', 191)->nullable();
                $table->text('description')->nullable();
                $table->integer('quantity')->nullable();
                $table->decimal('amount_paid', 11, 2)->nullable();
                $table->decimal('amount_due', 11, 2)->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_details');
    }
}
