<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('invoices')) {
            Schema::create('invoices', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('old_invoice_id')->nullable();
                $table->bigInteger('deal_id');
                $table->date('invoice_date')->nullable();
                $table->date('invoice_due_date')->nullable();
                $table->text('remarks')->nullable();
                $table->enum('currency', ['AUD', 'PH'])->default('AUD');
                $table->decimal('sub_total', 11, 2)->nullable();
                $table->tinyInteger('is_gst')->default(1);
                $table->decimal('total_due', 11, 2)->nullable();
                $table->decimal('total_paid', 11, 2)->nullable();
                $table->enum('invoice_status', ['Unpaid', 'Partial', 'Paid', 'Void', 'Overdue'])->default('Unpaid');
                $table->integer('user_id')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
