<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddActiveDateInDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deals', 'active_date')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->integer('is_active')->default(1)->after('user_id');
                $table->date('active_date')->nullable()->after('is_active');
            });
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'active_date')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['active_date', 'is_active']);
            });
        }
    }
}
