<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDealStatusIdInDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasColumn('deals', 'deal_status_id')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->integer('deal_status_id')->nullable()->after('deal_type_id');
            });
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'deal_status_id')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['deal_status_id']);
            });
        }
    }
}
