<?php

use App\Models\DealStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealStatusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('deal_statuses')) {
            Schema::create('deal_statuses', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('status_name', 255)->nullable();
                $table->timestamps();
                $table->softDeletes();
            });

            $types = [
                'New', 
                'In-Progress', 
                'Not Engaging', 
                'Contacted', 
                'Declined',
                'Confirmed',
                'Student Admission',
                'For Follow-up',
            ];

            foreach ($types as $value) {
                $dt = new DealStatus;
                $dt->status_name = $value;
                $dt->save();
            }
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deal_statuses');
    }
}
