<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOldCustomAttachmentIdInDealAttachmentFoldersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deal_attachment_folders', 'old_custom_attachment_id')) {
            Schema::table('deal_attachment_folders', function (Blueprint $table) {
                $table->integer('old_custom_attachment_id')->nullable()->after('id');
            });
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deal_attachment_folders', 'old_custom_attachment_id')) {
            Schema::table('deal_attachment_folders', function (Blueprint $table) {
                $table->dropColumn(['old_custom_attachment_id']);
            });
        }
    }
}
