<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOldUserIdInUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        if (!Schema::hasColumn('users', 'old_user_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->bigInteger('old_user_id')->nullable()->after('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'old_user_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn(['old_user_id']);
            });
        }
    }
}
