<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOldNoteIdInDealNotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deal_notes', 'old_note_id')) {
            Schema::table('deal_notes', function (Blueprint $table) {
                $table->bigInteger('old_note_id')->nullable()->after('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deal_notes', 'old_note_id')) {
            Schema::table('deal_notes', function (Blueprint $table) {
                $table->dropColumn(['old_note_id']);
            });
        }
    }
}
