<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPhoneInContactDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('contact_details', 'phones')) {
            Schema::table('contact_details', function (Blueprint $table) {
                $table->string('phones', 191)->nullable()->after('postcode');
                $table->integer('client_detail_id')->nullable()->after('person_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {   
        if (Schema::hasColumn('contact_details', 'phones')) {
            Schema::table('contact_details', function (Blueprint $table) {
                $table->dropColumn(['phones','deal_id']);
            });
        }

    }
}
