<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOldDealIdInDealsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('deals', 'old_deal_id')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->tinyInteger('old_deal_id')->nullable()->after('id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('deals', 'old_deal_id')) {
            Schema::table('deals', function (Blueprint $table) {
                $table->dropColumn(['old_deal_id']);
            });
        }
    }
}
