<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('deal_attachments')) {
            Schema::create('deal_attachments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('deal_id');
                $table->integer('deal_attachment_folder_id')->nullable();
                $table->string('path', 255)->nullable();
                $table->string('name', 255)->nullable();
                $table->string('hash_name', 255)->nullable();
                $table->integer('size')->nullable();
                $table->string('mime_type', 50)->nullable();
                $table->string('ext', 10)->nullable();
                $table->string('_input', 255)->nullable();
                $table->integer('user_id')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deal_attachments');
    }
}
