<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddClientMemberInClientDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {   
        if (!Schema::hasColumn('client_details', 'client_member')) {
            Schema::table('client_details', function (Blueprint $table) {
                $table->integer('client_member')->default(0)->after('college_currently_enroled');
                $table->string('client_member_card_no', 50)->default(0)->after('client_member');
            });
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('client_details', 'client_member')) {
            Schema::table('client_details', function (Blueprint $table) {
                $table->dropColumn(['client_member', 'client_member_card_no']);
            });
        }
    }
}
