<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('client_details')) {
            Schema::create('client_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('deal_id');
                $table->string('customer_id', 10)->nullable();
                $table->string('old_customer_id', 50)->nullable();
                $table->integer('nationality_id')->nullable();
                $table->integer('current_visa_status')->nullable();
                $table->date('expiration_date')->nullable();
                $table->string('passport_no', 50)->nullable();
                $table->tinyInteger('fifth_call')->default(0);
                $table->string('college_currently_enroled', 255)->nullable();
                $table->string('referrer_customer_id')->nullable();
                $table->longText('hear_about_us')->nullable();
                $table->integer('agent_id')->nullable();
                $table->integer('assigned_to')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_details');
    }
}
