<?php

use App\Models\DealSource;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealSourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('deal_sources')) {
            Schema::create('deal_sources', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('source_name', 255)->nullable();
                $table->timestamps();
            });

            $types = [
                'Self-Generated', 
                'Inbound Call', 
                'Tradeshow', 
                'Referral', 
                'Outbound Call',
                'Social Media',
                'Email Marketing',
                'Walk-in',
                'Groupon',
                'Agents',
                'Appointment',
            ];

            foreach ($types as $value) {
                $dt = new DealSource;
                $dt->source_name = $value;
                $dt->save();
            }
        
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deal_sources');
    }
}
