<?php

use App\Models\DealType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('deal_types')) {
            Schema::create('deal_types', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type', 255)->nullable();
                $table->timestamps();
                $table->softDeletes();
            });

            $types = ['Leads', 'Prospect', 'Opportunity', 'Won', 'Loss'];
            foreach ($types as $value) {
                $dt = new DealType;
                $dt->type = $value;
                $dt->save();
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deal_types');
    }
}
