<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('contact_details')) {
            Schema::create('contact_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('person_id');
                $table->string('address_1', 255)->nullable();
                $table->string('address_2', 255)->nullable();
                $table->integer('country_id')->nullable();
                $table->string('state', 50)->nullable();
                $table->string('postcode', 10)->nullable();
                $table->string('phone_1', 20)->nullable();
                $table->string('phone_2', 20)->nullable();
                $table->string('phone_3', 20)->nullable();
                $table->string('email', 255)->nullable();
                $table->string('email_alt', 255)->nullable();
                $table->string('emer_name', 255)->nullable();
                $table->string('emer_email', 255)->nullable();
                $table->string('emer_address', 255)->nullable();
                $table->string('emer_phone', 255)->nullable();
                $table->string('emer_relationship', 255)->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_details');
    }
}
