<?php

namespace App\Providers;

use App\Models\Menu;
use App\Models\Organisation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
        Schema::defaultStringLength(191);
        View::share('app_settings', Organisation::all());
        View::share('sidebar_menu', Menu::with(['sub_menus'])->orderBy('order')->get());
        
        // dd(Auth::user()->id);

        View::composer('*', function ($view) {
            $view->with('currentUser', Auth::user());
        });

        \JavaScript::put([
            'app_color' => Organisation::all()[0]->app_color,
            'add_on' => explode(',',Organisation::all()[0]->add_on),
        ]);
            
        // Laravel permissions - CREATE ROLES
        Role::findOrCreate('Super-Admin', 'web');
        Role::findOrCreate('Admin', 'web');
        Role::findOrCreate('User', 'web');
        Role::findOrCreate('Trainer', 'web');
        Role::findOrCreate('Staff', 'web');
        Role::findOrCreate('Trainee', 'web');
        Role::findOrCreate('Demo', 'web');
        Role::findOrCreate('Student', 'web');
        Role::findOrCreate('Agent', 'web');

        View::share('NoDemoRole', implode('|', Role::where('name', '!=', 'Demo')->pluck('name')->toArray()) );

    }
}
