<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class TimelogBreak extends Model implements AuditableContract
{
    //
    use SoftDeletes;
    use Auditable;

    protected $auditableEvents = [
        'deleted',
        'restored',
        'updated',
        'created'
    ];
    
    protected $fillable = [
        'timelog_id',
        'break_start',
        'break_end',
        'total_breaks',
        'notes',
        'last_user_activity',
    ];
    protected $dates = ['break_start', 'break_end', 'created_at'];

    public function timelog()
    {
        return $this->belongsTo(Timelog::class);
    }
}
