<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class Timelog extends Model implements AuditableContract
{
    //
    use SoftDeletes;
    use Auditable;

    protected $auditableEvents = [
        'deleted',
        'restored',
        'updated',
        'created'
    ];
    
    protected $fillable = [
        'user_id',
        'time_in',
        'time_out',
        'total_mins_break',
        'total_mins_tardy',
        'on_leave',
        'is_absent',
        'last_activity',
    ];
    protected $dates = ['created_at'];

    protected $casts = [
        'time_in' => 'datetime',
        'time_out' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function breaks()
    {
        return $this->hasMany(TimelogBreak::class)->orderBy('break_start', 'desc');
    }

    public static function boot()
    {
        parent::boot();
        self::deleting(function ($timelog) {
            $timelog->breaks()->each(function($b){
                $b->delete();
            });
        });
    }
}
