<?php

namespace App\Models\TaskOrganiser;

use Illuminate\Database\Eloquent\Model;

class TaskHasFile extends Model
{
    //
    protected $connection= 'kb';

    public $timestamps = false;

    protected $fillable = [
        'name',
        'path',
        'is_image',
        'task_id',
        'date',
        'user_id',
        'size',
    ];

    public function user() {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function task() {
        return $this->belongsTo(User::class, 'task_id');
    }
}
