<?php

namespace App\Models\TaskOrganiser;

use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
    //
    protected $connection= 'kb';

    public $timestamps = false;

    protected $fillable = [
        'title',
        'description',
        'date_creation',
        'date_completed',
        'date_due',
        'color_id',
        // 'project_id',
        'column_id',
        // 'owner_id',
        'position',
        'score',
        'is_active',
        'category_id',
        // 'creator_id',
        'date_modification',
        'reference',
        'date_started',
        'time_spent',
        'time_estimated',
        'swimlane_id',
        'date_moved',
        'recurrence_status',
        'recurrence_trigger',
        'recurrence_factor',
        'recurrence_timeframe',
        'recurrence_basedate',
        'recurrence_parent',
        'recurrence_child',
        'priority',
        'external_provider',
        'external_uri',
    ];

    public function attachments() {
        return $this->hasMany(TaskHasFile::class);
    }

    public function comments() {
        return $this->hasMany(Comment::class);
    }

    public function links() {
        return $this->hasMany(TaskHasLink::class);
    }

    public function subtasks() {
        return $this->hasMany(Subtask::class);
    }

    public function done_subtasks() {
        return $this->hasMany(Subtask::class)->where('status', 2);
    }

    public function owner() {
        return $this->belongsTo(User::class, 'owner_id');
    }

    public function creator() {
        return $this->belongsTo(User::class, 'creator_id');
    }

    public function get_column() {
        return $this->belongsTo(Column::class, 'column_id');
    }

    public function project() {
        return $this->belongsTo(Project::class, 'project_id');
    }

}
