<?php

namespace App\Models\TaskOrganiser;

use Illuminate\Database\Eloquent\Model;

class SubtaskTimeTracking extends Model
{
    //
    protected $connection= 'kb';

    public $timestamps = false;

    protected $table = 'subtask_time_tracking';

    protected $fillable = [
        'start',
        'end',
        'time_spent',
    ];

    public function user() {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function subtask() {
        return $this->belongsTo(Subtask::class);
    }
}
