<?php

namespace App\Models\TaskOrganiser;

use Illuminate\Database\Eloquent\Model;

class Subtask extends Model
{
    //
    protected $connection= 'kb';

    public $timestamps = false;

    protected $fillable = [
        'title',
        'status',
        'time_estimated',
        'time_spent',
        'task_id',
        'position',
        'user_id',
    ];

    public function user() {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function subtask_time_tracking() {
        return $this->hasMany(SubtaskTimeTracking::class)->orderBy('id', 'desc');
    }

}
