<?php

namespace App\Models\TaskOrganiser;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    //
    protected $connection= 'kb';

    public function columns()
    {
        return $this->hasMany(Column::class)->orderBy('position', 'asc');
    }

    public function project_has_users()
    {
        return $this->hasMany(ProjectHasUser::class);
    }

    public function swimlanes() {
        return $this->hasMany(Swimlane::class, 'project_id', 'id')->where('is_active', 1)->orderBy('position','asc');
        // return $this->hasMany(Swimlane::class);
    }
}
