<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Questionnaire extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;
    protected $auditableEvents = [
        'deleted',
        'restored',
        'updated',
        'created'
    ];

    protected $fillable = ['process_id', 'client_name', 'forms', 'status'];
    protected $casts = ['forms' => 'array'];

    public function questionnaire_attachments()
    {
        return $this->hasMany(QuestionnaireAttachment::class, 'questionnaire_id');
    }
}
