<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;


    protected $fillable = [
        'old_payment_id',
        'payment_date',
        'trxn_code',
        'remarks',
        'payment_type',
        'source',
        'amount',
        'status',
        'payment_method_id'
    ];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }

    public function payment_details()
    {
        return $this->hasMany(PaymentDetail::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function payment_method()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
}
