<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceDetail extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;


    protected $fillable = [
        'old_invoice_detail_id',
        'line_item_title',
        'description',
        'quantity',
        'amount_paid',
        'amount_due',
    ];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }
}
