<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;


    protected $fillable = [
        'old_invoice_id',
        'invoice_date',
        'invoice_due_date',
        'remarks',
        'currency',
        'sub_total',
        'is_gst',
        'total_due',
        'total_paid',
        'invoice_status',
    ];

    public function deal()
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function invoice_details()
    {
        return $this->hasMany(InvoiceDetail::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}
