<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class DealAttachmentFolder extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'folder_name', 'old_custom_attachment_id'
    ];
    
    public function deal() 
    {
        return $this->belongsTo(Deal::class);
    }
    
    public function attachments()
    {
        return $this->hasMany(DealAttachment::class);
    }
}
