<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class DealAttachment extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'old_attachment_id',
        'path',
        'no_attachment',
        'name',
        'hash_name',
        'size',
        'mime_type',
        'ext',
        '_input',
    ];

    protected $auditableEvents = [
        'deleted',
        'restored',
        'updated',
        'created'
    ];

    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    public function deal() 
    {
        return $this->belongsTo(Deal::class);
    }

    public function deal_attachment_folder()
    {
        return $this->belongsTo(DealAttachmentFolder::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
