<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deal extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = ['deal_type_id', 'user_id', 'deal_source_id', 'deal_status_id', 'old_deal_id', 'active_date', 'is_test','is_online_inquiry', 'comments'];

    // protected $with = ['party'];

    public function party()
    {
        return $this->belongsTo(Party::class);
    }

    public function getParty()
    {
        return $this->belongsTo(Party::class);
    }

    public function deal_type()
    {
        return $this->belongsTo(DealType::class);
    }

    public function deal_status()
    {
        return $this->belongsTo(DealStatus::class);
    }

    public function deal_source()
    {
        return $this->belongsTo(DealSource::class);
    }

    public function client_detail()
    {
        return $this->hasOne(ClientDetail::class, 'deal_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function notes()
    {
        return $this->hasMany(DealNote::class)->where('note_type', 'note')->orderBy('id', 'desc');
    }

    public function convos()
    {
        return $this->hasMany(DealNote::class)->where('note_type', 'convo')->orderBy('id', 'desc');
    }

    public function attachments()
    {
        return $this->hasMany(DealAttachment::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class)->orderBy('id', 'desc');
    }

    public function services()
    {
        return $this->hasMany(ClientService::class)->orderBy('id', 'desc');
    }

}
